/*
 * pattern.h: interface for the pattern matching used in template matches.
 *
 * See Copyright for the status of this software.
 *
 * Daniel.Veillard@imag.fr
 */

#ifndef __XML_XSLT_PATTERN_H__
#define __XML_XSLT_PATTERN_H__

#include "xsltInternals.h"

#ifdef __cplusplus
extern "C" {
#endif

/*
 * The implementation of patterns is kept private
 */
typedef struct _xsltCompMatch xsltCompMatch;
typedef xsltCompMatch *xsltCompMatchPtr;

/*
 * Pattern related interfaces
 */

xsltCompMatchPtr xsltCompilePattern	(const xmlChar *pattern);
void		 xsltFreeCompMatchList	(xsltCompMatchPtr comp);
int		 xsltTestCompMatchList	(xsltTransformContextPtr ctxt,
					 xmlNodePtr node,
					 xsltCompMatchPtr comp);

/*
 * Template related interfaces
 */
int		xsltAddTemplate		(xsltStylesheetPtr style,
					 xsltTemplatePtr cur,
					 const xmlChar *mode,
					 const xmlChar *modeURI);
xsltTemplatePtr	xsltGetTemplate		(xsltTransformContextPtr ctxt,
					 xmlNodePtr node,
					 xsltStylesheetPtr style);
void		xsltFreeTemplateHashes	(xsltStylesheetPtr style);
int		xsltMatchPattern	(xsltTransformContextPtr ctxt,
					 xmlNodePtr node,
					 const xmlChar *pattern);

#ifdef __cplusplus
}
#endif

#endif /* __XML_XSLT_PATTERN_H__ */

