/** 
 * XMLSec library
 * 
 * Supported Algorithms definitions
 * 
 * See Copyright for the status of this software.
 * 
 * Author: Aleksey Sanin <aleksey@aleksey.com>
 */
#ifndef __XMLSEC_ALGORITHMS_H__
#define __XMLSEC_ALGORITHMS_H__    

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */ 

#include <libxml/tree.h>

/* 
 * Algorithms usage constants
 */
#define xmlSecAlgUsageUnknown			0
#define xmlSecAlgUsageDSigC14N			1
#define xmlSecAlgUsageDSigTransform		2
#define xmlSecAlgUsageDSigDigest		4
#define xmlSecAlgUsageDSigSignature		8
		
typedef long xmlSecAlgUsage;

/*
 * Algorithms constants
 */
typedef enum _xmlSecAlgorithm {
    /* invalid/unknown */
    xmlSecAlgorithmDebugDump = -100,
    xmlSecAlgorithmInvalid = -1,
    xmlSecAlgorithmUnknown = 0,

    /* digest methods */
    xmlSecDigestSha1,
        
    /* encoding */
    xmlSecEncBase64,

    /* MAC */ 
    xmlSecMacHmacSha1,
    
    /* signature */ 
    xmlSecSignDsaSha1,
    xmlSecSignRsaSha1,
         
    /* c14n methods */
    xmlSecC14NInclusive,
    xmlSecC14NInclusiveWithComments,
    xmlSecC14NExclusive,
    xmlSecC14NExclusiveWithComments,
    
    /* transforms */
    xmlSecTransformXslt,
    xmlSecTransformXpath,
    xmlSecTransformEnvSign,
    
    /* encryption algorithms */  
    
    /* utility algorithms */
    xmlSecInputLocalFile,
    xmlSecInputHttpFile,
    xmlSecInputFtpFile,
    
    /* the last algorithm */
    xmlSecAlgorithmLast
} xmlSecAlgorithm;

/*
 * Converting algorithm constants to href and vice versa, 
 * checking the usage of algorithm
 */
xmlSecAlgorithm		xmlSecHref2Algorithm		(const xmlChar* href);
const xmlChar* 		xmlSecAlgorithm2Href		(xmlSecAlgorithm method);
int			xmlSecAlgCheckUsage		(xmlSecAlgorithm method,
							 xmlSecAlgUsage usage);
int			xmlSecAlgCheckUsageHref		(const xmlChar* href,
							 xmlSecAlgorithm* method,
							 xmlSecAlgUsage usage);
const xmlChar* 		xmlSecAlgCheckUsageAlg		(xmlSecAlgorithm method,
							 xmlSecAlgUsage usage);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __XMLSEC_ALGORITHMS_H__ */

