/** 
 * Base64 Algorithm
 * 
 * See Copyright for the status of this software.
 * 
 * Author: Aleksey Sanin <aleksey@aleksey.com>
 */
#ifndef __XMLSEC_BASE64_H__
#define __XMLSEC_BASE64_H__    

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */ 

#include <xmlsec/algorithms.h>
#include <xmlsec/keysmgmt.h>
#include <xmlsec/transforms.h>

/* 
 * It turns out that openssl has no Base64 context :(
 * So I have to implement this myself
 */

#define XMLSEC_BASE64_LINESIZE		64

/**
 * Base64 Context
 */
typedef struct _xmlSecBase64Ctx xmlSecBase64Ctx, *xmlSecBase64CtxPtr;
xmlSecBase64CtxPtr	xmlSecBase64CtxCreate		(int encode,
							 int columns);
void			xmlSecBase64CtxDestroy		(xmlSecBase64CtxPtr ctx);
int 			xmlSecBase64CtxInit		(xmlSecBase64CtxPtr ctx);
int 			xmlSecBase64CtxUpdate		(xmlSecBase64CtxPtr ctx,
							 const unsigned char *in, 
						         size_t inLen, 
							 unsigned char *out,
							 size_t outLen);
int			xmlSecBase64CtxFinal		(xmlSecBase64CtxPtr ctx,
							 unsigned char *out,
							 size_t outLen);

/**
 * Base64 binary transform
 */
xmlSecBinTransformPtr	xmlSecBase64TransformCreate 	(xmlNodePtr transformNode, 
							 int encodes);

/**
 * Standalone routine to do base64 encode/decode "at once"
 */
xmlChar*		xmlSecBase64Encode		(const unsigned char *buf,
							 size_t len,
							 int columns);
int			xmlSecBase64Decode		(const xmlChar* str,
							 unsigned char *buf,
							 size_t len);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __XMLSEC_BASE64_H__ */

