/** 
 * XMLSec library
 *
 * C14N transforms
 * 
 * See Copyright for the status of this software.
 * 
 * Author: Aleksey Sanin <aleksey@aleksey.com>
 */
#ifndef __XMLSEC_C14N_H__
#define __XMLSEC_C14N_H__    

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */ 

#include <libxml/tree.h>

#include <xmlsec/algorithms.h>


typedef struct _xmlSecC14NTransform xmlSecC14NTransform, *xmlSecC14NTransformPtr;

xmlSecC14NTransformPtr	xmlSecC14NTransformCreate	(xmlSecAlgorithm alg,
							 xmlNodePtr node);
void			xmlSecC14NTransformDestroy	(xmlSecC14NTransformPtr ptr);

int			xmlSecC14NTransformExecute	(xmlSecC14NTransformPtr ptr,
							 xmlDocPtr doc, 
							 xmlNodeSetPtr nodes,
							 xmlOutputBufferPtr output);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __XMLSEC_C14N_H__ */

