/** 
 * XMLSec library
 *
 * DSA algorithm support
 * 
 * See Copyright for the status of this software.
 * 
 * Author: Aleksey Sanin <aleksey@aleksey.com>
 */
#ifndef __XMLSEC_DSA_H__
#define __XMLSEC_DSA_H__    

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */ 

#include <openssl/dsa.h>
#include <libxml/tree.h>

#include <xmlsec/algorithms.h>
#include <xmlsec/keysmgmt.h>
#include <xmlsec/transforms.h>

typedef struct _xmlSecDsaKey {
    /* xmlSecKey structure */
    xmlSecAlgorithm		algorithm;
    xmlChar*			name;
    size_t			size;
    xmlSecKeyDestroyCallback	destroyCallback;    
    xmlNodePtr			node;
    int				privateKey;

    /* DSA */
    DSA				*dsa;
} xmlSecDsaKey, *xmlSecDsaKeyPtr;

/**
 * DSA Key 
 */
xmlSecDsaKeyPtr		xmlSecDsaKeyCreate		(const xmlChar *name);
xmlSecDsaKeyPtr		xmlSecDsaKeyRead		(const xmlDocPtr doc,
							 const xmlNodePtr dsaKeyValueNode,
							 const xmlChar *name);
int			xmlSecDsaKeyWrite		(const xmlSecDsaKeyPtr ptr,
							 xmlDocPtr doc,
							 xmlNodePtr parent,
							 int writePrivateKey);
/**
 * DSA-SHA1 Binary transform
 */
xmlSecBinTransformPtr	xmlSecDsaSha1TransformCreate 	(int encode, 
						         const xmlSecDsaKeyPtr key,
							 const xmlChar *digest);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __XMLSEC_DSA_H__ */

