/** 
 * XMLSec library
 *
 * HMAC algorithm support
 * 
 * See Copyright for the status of this software.
 * 
 * Author: Aleksey Sanin <aleksey@aleksey.com>
 */
#ifndef __XMLSEC_HMAC_H__
#define __XMLSEC_HMAC_H__    

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */ 

#include <libxml/tree.h>

#include <xmlsec/keysmgmt.h>
#include <xmlsec/algorithms.h>
#include <xmlsec/transforms.h>

typedef struct _xmlSecHmacKey {
    /* xmlSecKey */
    xmlSecAlgorithm		algorithm;
    xmlChar*			name;
    size_t			size;
    xmlSecKeyDestroyCallback	destroyCallback;    
    xmlNodePtr			node;
    int				privateKey;

    /* hmac */
    size_t			keyLen;
    unsigned char 		key[1];
} xmlSecHmacKey, *xmlSecHmacKeyPtr;

/**
 * HMAC key
 */
xmlSecHmacKeyPtr	xmlSecHmacKeyCreate		(const xmlChar* name,
							 const unsigned char *key,
							 size_t keyLen);
xmlSecHmacKeyPtr	xmlSecHmacKeyRead		(const xmlDocPtr doc, 
							 const xmlNodePtr hmacKeyValueNode, 
							 const xmlChar* name);
int			xmlSecHmacKeyWrite		(const xmlSecHmacKeyPtr key, 
							 xmlDocPtr doc, 
							 xmlNodePtr parent,
							 int writePrivateKey); 
/**
 * HMAC binary transform
 */							 
xmlSecBinTransformPtr	xmlSecHmacTransformCreate 	(xmlNodePtr transformNode,
							 const xmlSecHmacKeyPtr data);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __XMLSEC_HMAC_H__ */

