/** 
 * XMLSec library
 *
 * Memory buffer and IO transforms
 *
 * See Copyright for the status of this software.
 * 
 * Author: Aleksey Sanin <aleksey@aleksey.com>
 */
#ifndef __XMLSEC_IO_H__
#define __XMLSEC_IO_H__    

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */ 

#include <libxml/tree.h>

#include <xmlsec/keysmgmt.h>
#include <xmlsec/algorithms.h>
#include <xmlsec/transforms.h>


/**
 * Memory buffer binary transform
 */
typedef xmlSecBinTransformPtr 	xmlSecBufferTransformPtr;
xmlSecBufferTransformPtr xmlSecBufferTransformCreate	(void);
xmlBufferPtr		 xmlSecBufferTransformGet	(xmlSecBufferTransformPtr ptr);

/**
 * IO binary trasnform
 */
xmlSecBinTransformPtr 	xmlSecUriTransformCreate	(const char* uri, 
							 int read);

/*
 * debug transform: dump data to a file and pass to next transform
 */
xmlSecBinTransformPtr	xmlSecDebugDumpTransformCreate	(const char *filename);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __XMLSEC_IO_H__ */

