/** 
 * XMLSec library
 *
 * Keys Mangement
 * 
 * See Copyright for the status of this software.
 * 
 * Author: Aleksey Sanin <aleksey@aleksey.com>
 */
#ifndef __XMLSEC_KEYSMGMT_H__
#define __XMLSEC_KEYSMGMT_H__    

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */ 

#include <xmlsec/algorithms.h>

/** 
 * Base Key 
 */
typedef struct _xmlSecKey xmlSecKey, *xmlSecKeyPtr;
typedef void  (*xmlSecKeyDestroyCallback)(xmlSecKeyPtr ptr);

struct _xmlSecKey {
    xmlSecAlgorithm		algorithm;
    xmlChar*			name;
    size_t			size;
    xmlSecKeyDestroyCallback	destroyCallback;    
    xmlNodePtr			node;
    int				privateKey;
};

void 			xmlSecKeyDestroy		(xmlSecKeyPtr ptr);


/**
 * Read/write KeyValue element 
 */
xmlSecKeyPtr		xmlSecKeyValueRead		(const xmlDocPtr doc, 
							 const xmlNodePtr keyValueNode, 
							 const xmlChar *name);
xmlNodePtr		xmlSecKeyValueFindNode		(xmlDocPtr doc, 
							 xmlNodePtr keyValueNode, 
		    					 xmlSecAlgorithm alg, 
							 int addIfNotFound);
int			xmlSecKeyValueWrite		(const xmlSecKeyPtr key, 
							 xmlDocPtr doc, 
							 xmlNodePtr keyValueNode,
							 int writePrivateKey);
xmlNodePtr		xmlSecKeyValueAdd		(xmlDocPtr doc, 
							 xmlNodePtr parent, 
							 xmlNodePtr prev);
 
/**
 * Read/write KeyInfo element
 */							 							 
xmlSecKeyPtr		xmlSecKeyInfoRead		(const xmlDocPtr doc, 
							 const xmlNodePtr keyInfoNode, 
							 xmlSecAlgorithm alg); 
xmlNodePtr		xmlSecKeyInfoFindNode		(xmlDocPtr doc, 
							 xmlNodePtr keyInfoNode,
							 xmlSecAlgorithm alg, 
							 int addIfNotFound);
int			xmlSecKeyInfoWrite		(const xmlSecKeyPtr key,
							 xmlDocPtr doc, 
							 xmlNodePtr keyInfoNode, 
							 int writePrivateKey);
xmlNodePtr		xmlSecKeyInfoAdd		(xmlDocPtr doc, 
							 xmlNodePtr parent, 
							 xmlNodePtr prev);

/** 
 * XMLSec KeyMngr
 */
typedef struct _xmlSecKeyMngr xmlSecKeyMngr, *xmlSecKeyMngrPtr;
typedef void 		(*xmlSecKeyMngrDestroyCalllback)(xmlSecKeyMngrPtr ptr);
typedef int 		(*xmlSecKeyMngrAddKeyCallback)	(xmlSecKeyMngrPtr ptr,
							 xmlSecKeyPtr key,  
							 void *context);
typedef xmlSecKeyPtr 	(*xmlSecKeyMngrFindKeyCallback)	(xmlSecKeyMngrPtr ptr, 
							 xmlSecAlgorithm alg,
						         const xmlChar* name,
							 void *context);
struct _xmlSecKeyMngr {	
    xmlSecKeyMngrDestroyCalllback	destroyCallback;
    xmlSecKeyMngrAddKeyCallback		addKeyCallback;
    xmlSecKeyMngrFindKeyCallback	findKeyCallback;
    void				*data;
};

void 			xmlSecKeyMngrDestroy		(xmlSecKeyMngrPtr ptr);
int			xmlSecKeyMngrAddKey		(xmlSecKeyMngrPtr ptr,
							 xmlSecKeyPtr key,  
							 void *context);
xmlSecKeyPtr		xmlSecKeyMngrFindKey		(xmlSecKeyMngrPtr ptr,
							 xmlSecAlgorithm alg,
							 const xmlChar* name,
							 void *context);
/**
 * Simple Keys Manager
 */
typedef xmlSecKeyMngr xmlSecSimpleKeyMngr, *xmlSecSimpleKeyMngrPtr;

xmlSecSimpleKeyMngrPtr	xmlSecSimpleKeyMngrCreate	(void);
int			xmlSecSimpleKeyMngrLoad		(xmlSecSimpleKeyMngrPtr ptr,
							 const char *uri); 
int			xmlSecSimpleKeyMngrSave		(const xmlSecSimpleKeyMngrPtr ptr, 
							 const char *uri,
							 int writePrivateKey);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __XMLSEC_KEYSMGMT_H__ */

