/** 
 * XMLSec library
 *
 * RSA algorithm support
 * 
 * See Copyright for the status of this software.
 * 
 * Author: Aleksey Sanin <aleksey@aleksey.com>
 */
#ifndef __XMLSEC_RSA_H__
#define __XMLSEC_RSA_H__    

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */ 

#include <openssl/rsa.h>
#include <libxml/tree.h> 

#include <xmlsec/algorithms.h>
#include <xmlsec/keysmgmt.h>
#include <xmlsec/transforms.h>

typedef struct _xmlSecRsaKey {
    /* xmlSecKey */
    xmlSecAlgorithm		algorithm;
    xmlChar*			name;
    size_t			size;
    xmlSecKeyDestroyCallback	destroyCallback;    
    xmlNodePtr			node;
    int				privateKey;

    /* RSA */
    RSA				*rsa;
} xmlSecRsaKey, *xmlSecRsaKeyPtr;

/**
 * RSA key
 */ 
xmlSecRsaKeyPtr		xmlSecRsaKeyCreate		(const xmlChar *name);
xmlSecRsaKeyPtr		xmlSecRsaKeyRead		(const xmlDocPtr doc,
							 const xmlNodePtr rsaKeyValueNode,
							 const xmlChar *name);
int			xmlSecRsaKeyWrite		(const xmlSecRsaKeyPtr ptr,
							 xmlDocPtr doc,
							 xmlNodePtr parent,
							 int writePrivateKey);

/**
 * RSA-SHA1 binary transform
 */							 
xmlSecBinTransformPtr	xmlSecRsaSha1TransformCreate 	(int encode, 
							 const xmlSecRsaKeyPtr key,
							 const xmlChar* digest);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __XMLSEC_RSA_H__ */

