/** 
 * XMLSec library
 *
 * "XML Digital Signture" implementation
 *  http://www.w3.org/TR/xmldsig-core/
 *  http://www.w3.org/Signature/Overview.html
 * 
 * See Copyright for the status of this software.
 * 
 * Author: Aleksey Sanin <aleksey@aleksey.com>
 */
#ifndef __XMLSEC_XMLDSIG_H__
#define __XMLSEC_XMLDSIG_H__    

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */ 

#include <libxml/tree.h>
#include <libxml/parser.h> 

#include <xmlsec/algorithms.h>
#include <xmlsec/keysmgmt.h>
#include <xmlsec/transforms.h>

/** 
 * DSig context
 */
typedef struct _xmlDSigCtx {
    xmlSecKeyMngrPtr	keyMgr;
    void		*context; /* app specific ctx to be passed to key Manager */
    int			writeKey; /* if the flag is set then we write public 
				     key in the signature */
    
    /* debug only  */
    const char		*debugFileNamesTmpl; /* the template for filenames to print 
						out intermediate results (for example,
						"test-%d.xml" ) */
    int			debugCounter;		
} xmlDSigCtx, *xmlDSigCtxPtr;


/**
 * DSig results (todo)
 */ 
typedef void* xmlDSigResultsPtr; 
 
xmlDSigCtxPtr		xmlDSigCtxCreate		(xmlSecKeyMngrPtr keyMgr,
							 void *context);
void 			xmlDSigCtxDestroy		(xmlDSigCtxPtr ctx);

int			xmlDSigValidate			(xmlDSigCtxPtr ctx,
							 xmlDocPtr doc,
							 xmlNodePtr cur,
							 xmlDSigResultsPtr results); 
int			xmlDSigGenerate			(xmlDSigCtxPtr ctx,
							 xmlDocPtr doc,
							 xmlNodePtr cur,
							 xmlDSigResultsPtr results);
xmlNodePtr		xmlDSigCreate			(xmlDSigCtxPtr ctx,
							 xmlDocPtr doc,
							 xmlSecAlgorithm c14nMethod,
							 void *c14nData,
							 xmlSecAlgorithm signMethod,
							 void *signData);
xmlNodePtr		xmlDSigReferenceAdd		(xmlDSigCtxPtr ctx,
							 xmlDocPtr doc,
							 xmlNodePtr signatureNode,
							 const xmlChar *uri,
							 xmlSecAlgorithm digestMethod,
							 void *digestData);
xmlNodePtr		xmlDSigTransformAdd		(xmlDSigCtxPtr ctx,
							 xmlDocPtr doc,
							 xmlNodePtr referenceNode,
							 xmlSecAlgorithm transformMethod,
							 void *transformData);
							 
#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __XMLSEC_XMLDSIG_H__ */

