/** 
 * XMLSec library
 *
 * Common utility functions
 *
 * See Copyright for the status of this software.
 * 
 * Author: Aleksey Sanin <aleksey@aleksey.com>
 */
#ifndef __XMLSEC_XMLSEC_H__
#define __XMLSEC_XMLSEC_H__    

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */ 

#include <libxml/tree.h>
#include <libxml/xpath.h>

xmlNodePtr		xmlSecNewSibling		(xmlNodePtr parent, 
							 xmlNodePtr cur,
							 xmlNsPtr ns, 
							 const xmlChar* name);
xmlNodePtr		xmlSecAddSibling		(xmlNodePtr parent, 
							 xmlNodePtr prev, 
							 xmlNodePtr cur);
xmlNodePtr		xmlSecGetNextElementNode	(xmlNodePtr cur);
int			xmlSecCheckNodeName		(const xmlDocPtr doc, 
							 const xmlNodePtr cur, 
							 const xmlChar *name,
							 const xmlChar *ns);
xmlNodeSetPtr		xmlSecCreateChildsNodeSet	(const xmlDocPtr doc, 
							 const xmlNodePtr parent, 
							 xmlNodeSetPtr ptr, 
							 int withComments);
xmlDocPtr		xmlSecLoadFile			(const char *filename);
xmlDocPtr		xmlSecParseMemory		(const char *buffer, 
							 int size);
xmlNodePtr		xmlSecFindNode			(const xmlDocPtr doc, 
							 xmlNodePtr cur, 
							 const xmlChar* id);

/* XMLDSig namespace */
extern const xmlChar xmlDSigNs[];

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __XMLSEC_XMLSEC_H__ */

