/** 
 * XMLSec library
 *
 * XPath and Enveloped Signature transforms
 * 
 * See Copyright for the status of this software.
 * 
 * Author: Aleksey Sanin <aleksey@aleksey.com>
 */
#ifndef __XMLSEC_XPATH_H__
#define __XMLSEC_XPATH_H__    

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */ 

#include <libxml/tree.h>
#include <libxml/xpath.h>

#include <xmlsec/algorithms.h>
#include <xmlsec/transforms.h>

typedef struct _xmlSecXPathTransformData {
    char		*expression;
    char		**namespaces;
} xmlSecXPathTransformData, *xmlSecXPathTransformDataPtr;

xmlNodeSetPtr		xmlSecXPathTransformExecute	(xmlDocPtr ctxDoc,
							 xmlNodePtr ctxNode,
							 xmlDocPtr doc,
							 xmlNodeSetPtr nodes);
int			xmlSecXPathTrasnformAdd		(xmlDocPtr doc,
							 xmlNodePtr parent,
							 xmlSecXPathTransformDataPtr data);

xmlNodeSetPtr		xmlSecEnvSignTransformExecute	(xmlDocPtr ctxDoc,
							 xmlNodePtr ctxNode,
							 xmlDocPtr doc,
							 xmlNodeSetPtr nodes);
#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __XMLSEC_XPATH_H__ */

