#!/bin/sh 


testfiles="$testfiles merlin-exc-c14n-one/exc-signature.xml"
testfiles="$testfiles merlin-xmldsig-fifteen/signature-enveloped-dsa.xml"
testfiles="$testfiles merlin-xmldsig-fifteen/signature-enveloping-b64-dsa.xml"
testfiles="$testfiles merlin-xmldsig-fifteen/signature-enveloping-dsa.xml"
testfiles="$testfiles merlin-xmldsig-fifteen/signature-enveloping-hmac-sha1-40.xml"
testfiles="$testfiles merlin-xmldsig-fifteen/signature-enveloping-hmac-sha1.xml"
testfiles="$testfiles merlin-xmldsig-fifteen/signature-enveloping-rsa.xml"
testfiles="$testfiles merlin-xmldsig-fifteen/signature-external-b64-dsa.xml"
testfiles="$testfiles merlin-xmldsig-fifteen/signature-external-dsa.xml"
testfiles="$testfiles merlin-xmldsig-fourteen/signature.xml"
#testfiles="$testfiles merlin-xmldsig-sixteen/signature.xml"

topfolder=`pwd`
timestamp=`date +%Y%m%d_%H%M%S` 
tmpfile=/tmp/testDSig.$timestamp-$$.tmp
logfile=/tmp/testDSig.$timestamp-$$.log
script="$0"
keysfile=$topfolder/keys.xml

printRes() {
    if [ $? = 0 ]; then
	echo "   OK"
    else 
        echo " Fail"
    fi
    if [ -f .memdump ] ; then 
	cat .memdump >> $logfile 
    fi
}

execDSigTest() {    
    file=$topfolder/$1  

    printf "    Verify existing signature                            "
    $topfolder/testDSig verify --keys $keysfile $file >> $logfile 2>> $logfile
    printRes 

    printf "    Create new signature                                 "
    $topfolder/testDSig sign --keys $keysfile $file > $tmpfile 2>> $logfile
    printRes

    printf "    Verify new signature                                 "
    $topfolder/testDSig verify --keys $keysfile $tmpfile >> $logfile 2>> $logfile
    printRes

}

echo "--- testDSig started ($timestamp)"
echo "--- testDSig started ($timestamp)" >> $logfile

for i in `echo $testfiles` ;  do
    echo $i
    execDSigTest $i
done

rm -rf $tmpfile
echo "--- testDSig finished" >> $logfile
echo "--- testDSig finished"
echo "--- ATTENTION"
echo "--- Following tests require HTTP connection and will fail"
echo "--- if the connection could not be established:"
echo "---     merlin-xmldsig-fifteen/signature-external-*.xml"
echo "---     merlin-xmldsig-fourteen/signature.xml"
echo "---     merlin-xmldsig-sixteen/signature.xml"
echo "--- detailed log is written to  $logfile" 

