#!/bin/sh


topfolder=`pwd`
timestamp=`date +%Y%m%d_%H%M%S` 
tmpfile=/tmp/testKeys.$timestamp-$$.tmp
logfile=/tmp/testKeys.$timestamp-$$.log
script="$0"
keysfile=$topfolder/keys.xml

printRes() {
    if [ $? = 0 ]; then
	echo "   OK"
    else 
        echo " Fail"
    fi
    if [ -f .memdump ] ; then 
	cat .memdump >> $logfile 
    fi
}

printNotRes() {
    if [ $? = 0 ]; then
        echo " Fail"
    else 
	echo "   OK"
    fi
    if [ -f .memdump ] ; then 
	cat .memdump >> $logfile 
    fi
}

echo "--- testKeys started ($timestamp) ---"
echo "--- testKeys started ($timestamp) ---" >> $logfile

printf "    Creating new keys                                    "
$topfolder/testKeys createkeys $keysfile >> $logfile 2>> $logfile
printRes 

printf "    Loading it and dumping private keys                  "
echo > $tmpfile
$topfolder/testKeys privatekeys --keys $keysfile $tmpfile 2>> $logfile 
if [ $? = 0 ] ; then 
    diff $tmpfile $keysfile >> $logfile
    printRes
else 
    echo " Fail"
fi

printf "    Loading it and dumping public keys                   "
echo > $tmpfile
$topfolder/testKeys publickeys --keys $keysfile $tmpfile 2>> $logfile 
if [ $? = 0 ] ; then 
    diff $tmpfile $keysfile >> $logfile
    printNotRes
else 
    echo " Fail"
fi

rm -rf $tmpfile
echo "--- testKeys finished ---" >> $logfile
echo "--- testKeys finished ---"
echo "--- detailed log is written to  $logfile ---" 

